#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// 2D Adventures #3 - Better HexMod01.fsh  by  bombshell93    
//https://www.shadertoy.com/view/ldKyDt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//// ABSTRACT
//
//	The purpose behind this shader was a cleaner hex pattern than my previous
//	attempt and I figured while I was at it a truchet pattern, through some trial
//	and error and a bit of intuition I managed to find a way to get coordinates
//	for the lines which seemed to flow from one tile to the other.
//
//	Overall I'm happy with this shader, its looking cleaner than my previous
//	and the result is certainly more interesting, 
//
//// AUTHOR
//
//	Scott R Howell (Bombshell93)


#define SCALE .25

// hex axes

const vec2 X = vec2(1., 0.);
const vec2 Y = vec2(.5, .866);
const vec2 Z = vec2(-.5, .866);

// handy dandy pi bros

const float pi = 3.14;
const float pi2 = 6.28;

// used when finding hex coordinates and hex corners

const float sqrt3 = sqrt(3.);
const float sqrtc = sqrt3 / 3. * .5;

//// axial
//
//	finds axial coordniates via dot products of	axis vectors, effectively the
//	matrix multiplication I was using before albeit minimalized, based on the
//	"branchless method" found here:
//		https://www.redblobgames.com/grids/hexagons/more-pixel-to-hex.html

vec2 axial(vec2 p) {
    
    float y3 = p.y * sqrt3;
    return floor((
        floor(vec2(p.x * 2., y3 - p.x) + 1.)
        + (y3 + 1. + p.x)) / 3.);
}

//// pixel
//
//	finds pixel coordinates via axial coordinates

vec2 pixel(vec2 a) {
    
    return vec2(a.x - a.y * .5, a.y * sqrt3 * .5);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    
    vec2 uv = iTime * .33 + fragCoord / iResolution.y / SCALE;
    
    // get axial coordinates
    
    vec2 a = axial(uv);
    
    // find pixel coordinates of hex tile and distance from center
    
    vec2 h = pixel(a);
    vec2 d = uv - h;
    float da =  atan(d.y, d.x);
    d = abs(vec2(dot(d, X), dot(d, Y)));
    
    // find arbitrary index and use it to decide whether to use fipped corners
    
    float i = mod(mod(h.x, 3.) - mod(h.y * 2., 16.), 3.);
    float flip = step(1.5, i) * 2. - 1.;
    
    //find distance to corners
    
    vec2 dta = (pixel(a) + (X + Y) * flip / 3.) - uv
    	, dtb = (pixel(a) - (Y + Z) * flip / 3.) - uv
    	, dtc = (pixel(a) - (X - Z) * flip / 3.) - uv;
    float lta = dot(dta, dta)
        , ltb = dot(dtb, dtb)
        , ltc = dot(dtc, dtc);
    
    // find distance from nearest tile corner and mask the truchet pattern line
    
    float len = sqrt(min(lta, min(ltb, ltc)));
    float m = 1.;
    m *= step(0., len - sqrtc + .1) 
        - step(0., len - sqrtc - .1);
    
    // find the angle of the truchet pattern line
    
    vec2 dt = lta < ltb ? (lta < ltc ? dta : dtc) : (ltb < ltc ? dtb : dtc);
    vec3 pcol = vec3(1., mod(flip * atan(dt.x, dt.y) + iTime, pi / 3.), 0.);
    
    // find cube-like color and mix it with the truchet pattern respecting its mask
    
    float bgl = floor(mod(da - .52359, pi2) / (pi2 / 3.)) * .5;
    vec3 col = mix(vec3(0., 0., 1.) * (1. - bgl) + vec3(1.) * bgl, pcol, m);
    
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

